/*:
 * @target MZ
 * @plugindesc ステータス画面と装備画面のパラメータ（文字と数値）を非表示にします。
 * @author YourName
 *
 * @help
 * このプラグインは、RPGツクールMZのステータス画面および装備画面で
 * 攻撃力や防御力などのパラメータ（文字と数値）を非表示にします。
 * 名前、顔グラフィック、装備リストはそのまま表示されます。
 *
 * 使用方法:
 * 1. プラグインを「js/plugins/」フォルダに保存。
 * 2. プラグイン管理で有効化。
 * 3. 特別な設定は不要です。
 *
 * 注意:
 * - 他のステータス画面や装備画面を変更するプラグインとの競合に注意してください。
 * - プラグインリストの上位に配置することを推奨します。
 * - バックアップを取ってから使用してください。
 */

(() => {
  "use strict";

  // ステータス画面のパラメータを非表示
  Window_Status.prototype.drawParameters = function(x, y) {
    // 空の関数にしてパラメータを描画しない
  };

  // ステータス画面のブロック2を非表示（パラメータ部分）
  Window_Status.prototype.drawBlock2 = function(y) {
    // パラメータ部分をスキップ
  };

  // 装備画面のパラメータ描画を非表示（文字と数値）
  Window_EquipStatus.prototype.drawParameters = function(x, y) {
    // 空の関数にしてパラメータ全体を非表示
  };

  // パラメータ名（例: 「攻撃力」）を非表示
  Window_EquipStatus.prototype.drawParamName = function(x, y, paramId) {
    // 空の関数にしてパラメータ名を描画しない
  };

  // 現在のステータス値（例: 「100」）を非表示
  Window_EquipStatus.prototype.drawCurrentParam = function(x, y, paramId) {
    // 空の関数にして現在の値を描画しない
  };

  // 装備変更後のステータス値（例: 「120」）を非表示
  Window_EquipStatus.prototype.drawNewParam = function(x, y, paramId) {
    // 空の関数にして変更後の値を描画しない
  };

  // ステータス比較用の矢印（例: →）を非表示
  Window_EquipStatus.prototype.drawRightArrow = function(x, y, paramId) {
    // 空の関数にして矢印を描画しない
  };


  //「最強装備」と「全て外す」コマンドを非表示
  const _Window_EquipCommand_makeCommandList = Window_EquipCommand.prototype.makeCommandList;
  Window_EquipCommand.prototype.makeCommandList = function() {
    _Window_EquipCommand_makeCommandList.call(this);
    this._list = this._list.filter(command => 
      command.symbol !== "optimize" && command.symbol !== "clear"
    );
  };

  // 空装備を禁止（必ず何かを装備）
  const _Scene_Equip_onItemOk = Scene_Equip.prototype.onItemOk;
  Scene_Equip.prototype.onItemOk = function() {
    const item = this._itemWindow.item();
    const slotId = this._slotWindow.index();
    const actor = this.actor();
    // アイテムがnull（空装備）の場合、装備変更をキャンセル
    if (!item) {
      SoundManager.playBuzzer();
      this._itemWindow.activate();
      return;
    }
    // 通常の装備処理を続行
    _Scene_Equip_onItemOk.call(this);
  };

})();